package dtelements;

import java.util.ArrayList;
import java.util.Hashtable;

public class Example {

	private int ID;
	private ArrayList<Attribute> attributes;
	private ArrayList<String> values;
	private Hashtable<Attribute,String> attributeValueMap;
	private boolean classValue;
	
	public Example(int ID)
	{
		this.ID = ID;
		this.attributes = new ArrayList<Attribute>();
		this.values = new ArrayList<String>();
		this.attributeValueMap = new Hashtable<Attribute,String>();
	}
	
	public void addAttributeValue(Attribute attribute, String value)
	{
		this.attributes.add(attribute);
		this.values.add(value);
		this.attributeValueMap.put(attribute, value);
	}
	
	public boolean equals(Object o)
	{
		if(o instanceof Example)
		{
			if(((Example)o).getID() == this.ID)
			{
				return true;
			}
		}
		
		return false;
	}
	
	public int hashCode()
	{
		return this.ID;
	}
	
	
	public String getAttributeValue(Attribute attribute)
	{
		if(this.attributeValueMap.get(attribute) == null)
		{
			System.out.println("--" + this.toString());
			System.out.println("--" + attribute.toString());
		}
		return this.attributeValueMap.get(attribute);
	}

	public int getID() {
		return ID;
	}

	public ArrayList<Attribute> getAttributes() {
		return attributes;
	}

	public ArrayList<String> getValues() {
		return values;
	}

	public Hashtable<Attribute, String> getAttributeValueMap() {
		return attributeValueMap;
	}

	public boolean classValue() {
		return classValue;
	}

	public void setClassValue(boolean classValue) {
		this.classValue = classValue;
	}
	
	public String toString()
	{
		String ret = Integer.toString(this.ID) + ") ";
		
		ret += "Class = " + Boolean.toString(this.classValue) + "\t\t";
		
		for(int i = 0; i < this.attributes.size(); i++)
		{
			ret += this.attributes.get(i).toString() + " = " + this.values.get(i) + "\t\t";
		}
		
		return ret;
	}
	
}
